#ifndef ARCLIB_LOCK
#define ARCLIB_LOCK

#include <pthread.h>
#include <sys/time.h>

#include <cerrno>

#include <arc/common.h>

/** Common purpose lock/semaphor/mutex. */
class Lock {
	public:
		/** Constructor with default state unblocked. */
		inline Lock(bool blocked = false);

		/** Standard destructor. */
		inline ~Lock();

		/** Lock the mutex. */
		inline void Block();
		inline bool Block(int timeout);

		/** Unlock the mutex. */
		inline void Unblock();


	private:
		/** mutex. */
		pthread_mutex_t lock;
};


Lock::Lock(bool blocked) {
	pthread_mutex_init(&lock, NULL); // fast mutex
	if (blocked) Block();
}


Lock::~Lock() {
	Block(0);
	Unblock(); // race!
	pthread_mutex_destroy(&lock);
}


void Lock::Block() {
	pthread_mutex_lock(&lock);
}


bool Lock::Block(int timeout) {
	if (timeout != 0) return false; // not supported
	if (pthread_mutex_trylock(&lock)!=0) return false;
	return true;
}


void Lock::Unblock() {
	pthread_mutex_unlock(&lock);
}

#endif // ARCLIB_LOCK
