set workdir=`pwd`
if ( "$1" != "" ) then
  cd "$1" > /dev/null
endif

set topdir=`pwd`

if ( ! -f $topdir/setup.csh ) then 
  echo "Please execute from the same directory where setup.sh is residing"
  echo "    OR supply that directory as argument to this script."
  cd "$workdir" > /dev/null
  exit 1
endif

unset NORDUGRID_LOCATION
unset GLOBUS_LOCATION
unset GRID_SECURITY_DIR
unset X509_CERT_DIR
setenv NORDUGRID_LOCATION $topdir
setenv GLOBUS_LOCATION $topdir
setenv GRID_SECURITY_DIR $GLOBUS_LOCATION/etc
setenv X509_CERT_DIR     $GLOBUS_LOCATION/share/certificates
source $GLOBUS_LOCATION/etc/globus-user-env.csh 

if ( ! $?PYTHONPATH ) then
    setenv PYTHONPATH ''
else
    set DELIM=:
endif
if ( -r $NORDUGRID_LOCATION/lib*/python*/site-packages/_arclib.so ) then
  setenv PYTHONPATH "`dirname $NORDUGRID_LOCATION/lib*/python*/site-packages/_arclib.so`${DELIM}${PYTHONPATH}"
endif

if (! -r $topdir/ng-installed) then
  $topdir/bin/ng-finalize-setup
  echo $topdir >! $topdir/ng-installed
else if ( "$topdir" != "`cat $topdir/ng-installed`") then
  $topdir/bin/ng-finalize-setup
  echo $topdir >! $topdir/ng-installed
endif

cd "$workdir" > /dev/null
