if [ -r /etc/sysconfig/globus ]; then
  . /etc/sysconfig/globus
fi

GLOBUS_LOCATION=${GLOBUS_LOCATION:-/usr}

if [ -r "$GLOBUS_LOCATION/etc/globus-user-env.sh" ]; then
  . $GLOBUS_LOCATION/etc/globus-user-env.sh
fi

if [ "$GLOBUS_LOCATION" != "/usr" ]; then
  export GLOBUS_LOCATION
else
  unset GLOBUS_LOCATION
fi

export GLOBUS_TCP_PORT_RANGE
export GLOBUS_UDP_PORT_RANGE

if [ -r /etc/sysconfig/nordugrid ]; then
  . /etc/sysconfig/nordugrid
fi

NORDUGRID_LOCATION=${NORDUGRID_LOCATION:-/opt/nordugrid}

if [ -d "$NORDUGRID_LOCATION" ]; then
  export NORDUGRID_LOCATION
  export PATH=$NORDUGRID_LOCATION/bin:$PATH
fi

# Only set MANPATH if it is already set. Workaround on systems
# (eg. SuSE) which for some strange reason sets MANPATH
if [ -n "$MANPATH" ]; then
  export MANPATH=$NORDUGRID_LOCATION/man:$MANPATH
fi
