package Globus::Core::Paths;

require Exporter;

@ISA = qw(Exporter);

@EXPORT = qw($prefix $exec_prefix
	     $bindir $sbindir $libdir
	     $includedir $flavorincludedir
	     $datadir $libexecdir
	     $sysconfdir $sharedstatedir
	     $localstatedir
	     $setupdir $testdir
	     $perlmoduledir
	     $tmpdir
	     $local_tmpdir
	     $secure_tmpdir);

my $PACKAGE = "\$PACKAGE";
my $GLOBUS_FLAVOR_NAME = "\$GLOBUS_FLAVOR_NAME";

$prefix=$ENV{GLOBUS_LOCATION};
$prefix="/usr" if (!defined $prefix);
$exec_prefix=$ENV{GLOBUS_LOCATION};
$exec_prefix="/usr" if (!defined $exec_prefix);
$bindir="/usr/bin";
$sbindir="/usr/sbin";
$libdir="/usr/lib64";
$includedir="${prefix}/include/globus";
$flavorincludedir="${libdir}/globus/include";
$datadir="/usr/share";
$libexecdir="${datadir}/globus";
$sysconfdir="/etc";
$sharedstatedir="/usr/com";
$localstatedir="/var";
$setupdir="${datadir}/globus/setup";
$testdir="${datadir}/globus/test/${PACKAGE}";
$perlmoduledir="/usr/lib/perl5/vendor_perl/5.8.8";
$tmpdir="/tmp";
$local_tmpdir="${tmpdir}";
$secure_tmpdir="/var/tmp";

1;
