set workdir=`pwd`
if ( "$1" != "" ) then
  cd "$1" > /dev/null
endif

set topdir=`pwd`

if ( ! -f $topdir/setup.csh ) then 
  echo "Please execute from the same directory where setup.sh is residing"
  echo "    OR supply that directory as argument to this script."
  cd "$workdir" > /dev/null
  exit 1
endif
setenv ARC_LOCATION $topdir
setenv PATH $topdir/bin:$PATH
if ( $?LD_LIBRARY_PATH ) then
    set DELIM=:
else
    set DELIM=''
    setenv LD_LIBRARY_PATH ''
endif
foreach libdir ( lib lib64 )
  if ( -d $topdir/$libdir/lcgdm ) then
    setenv LD_LIBRARY_PATH $topdir/$libdir/lcgdm${DELIM}${LD_LIBRARY_PATH}
    set DELIM=:
  endif
end
unset libdir
unset DELIM
if ( $?LD_LIBRARY_PATH ) then
    set DELIM=:
else
    set DELIM=''
    setenv LD_LIBRARY_PATH ''
endif
foreach libdir ( lib lib64 )
  if ( -d $topdir/$libdir ) then
    setenv LD_LIBRARY_PATH $topdir/$libdir${DELIM}${LD_LIBRARY_PATH}
    set DELIM=:
  endif
end
unset libdir
unset DELIM
if ( $?PYTHONPATH ) then
    set DELIM=:
else
    set DELIM=''
    setenv PYTHONPATH ''
endif
foreach pydir ( $ARC_LOCATION/lib*/python*/site-packages                 $ARC_LOCATION/lib*/pyshared/python/*                 $ARC_LOCATION/share/pyshared/python/*                 $ARC_LOCATION/lib*/python-support/python-lfc                 $ARC_LOCATION/share/python-support/python-lfc )
    if ( -d $topdir/$pydir ) then
        setenv PYTHONPATH $pydir${DELIM}${PYTHONPATH}
        set DELIM=:
    endif
end
unset pydir
unset DELIM

setenv GLOBUS_LOCATION   $topdir
setenv X509_CERT_DIR     $GLOBUS_LOCATION/etc/grid-security/certificates
setenv GRID_SECURITY_DIR $GLOBUS_LOCATION/etc/grid-security
cd "$workdir" > /dev/null
