workdir=`pwd`
if [ "$1" ]; then cd "$1" > /dev/null; fi

topdir=`pwd`

if [ ! -f $topdir/setup.sh ];
then
  echo "Please execute from the same directory where setup.sh is residing"
  echo "    OR supply that directory as argument to this script."
  cd "$workdir" > /dev/null
  return 1
fi
ARC_LOCATION=$topdir
export ARC_LOCATION
PATH=$topdir/bin:$PATH
export PATH
DELIM=
if test -n "$LD_LIBRARY_PATH"
then
    DELIM=:
fi
for libdir in lib lib64
do
  if test -d $libdir
  then
    LD_LIBRARY_PATH=$topdir/$libdir/lcgdm$DELIM$LD_LIBRARY_PATH
    DELIM=:
  fi
done
unset libdir
unset DELIM
export LD_LIBRARY_PATH
DELIM=
if test -n "$LD_LIBRARY_PATH"
then
    DELIM=:
fi
for libdir in lib lib64
do
  if test -d $topdir/$libdir
  then
    LD_LIBRARY_PATH=$topdir/$libdir$DELIM$LD_LIBRARY_PATH
    DELIM=:
  fi
done
unset libdir
unset DELIM
export LD_LIBRARY_PATH
if test -n "$PYTHONPATH"
then
    DELIM=:
else
    DELIM=
fi
for pydir in $ARC_LOCATION/lib*/python*/site-packages              $ARC_LOCATION/lib*/pyshared/python/*              $ARC_LOCATION/share/pyshared/python/*              $ARC_LOCATION/lib*/python-support/python-lfc              $ARC_LOCATION/share/python-support/python-lfc
do
  if test -d $pydir
  then
    PYTHONPATH=$pydir${DELIM}${PYTHONPATH}
    DELIM=:
  fi
done
unset pydir
unset DELIM
export PYTHONPATH

GLOBUS_LOCATION=$topdir
export GLOBUS_LOCATION
X509_CERT_DIR=$GLOBUS_LOCATION/etc/grid-security/certificates
export X509_CERT_DIR
GRID_SECURITY_DIR=$GLOBUS_LOCATION/etc/grid-security
export GRID_SECURITY_DIR
cd "$workdir" > /dev/null
