my $gpath = $ENV{GPT_LOCATION};

# 
# Copyright 1999-2006 University of Chicago
# 
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# 
# http://www.apache.org/licenses/LICENSE-2.0
# 
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
# 


if (!defined($gpath))
{
  $gpath = "/usr";
}

@INC = (@INC, "$gpath/lib/perl");

require Grid::GPT::Setup;

my $metadata = new Grid::GPT::Setup(package_name => "globus_common_setup");

require Globus::Core::Paths;
my $setupdir = $Globus::Core::Paths::setupdir;
my $libexecdir = $Globus::Core::Paths::libexecdir;
my $bindir = $Globus::Core::Paths::bindir;

print "creating globus-sh-tools-vars.sh\n";
my $result = `$setupdir/findshelltools`;

for my $setupfile ('globus-sh-tools-vars.sh')
{
    $result = system("cp $setupdir/$setupfile $libexecdir/$setupfile");
    $result = system("chmod 0644 $libexecdir/$setupfile");
}

system("rm -f config.log config.status");

print "checking globus-hostname\n";

my $hostname = `$bindir/globus-hostname`;

$hostname =~ s/\w//g; #strip whitespace

if( ("$hostname" eq "localhost.") || 
	("$hostname" eq "localhost.localdomain") ||
	("$hostname" eq "."))
{
   print "WARNING: globus-hostname was unable to determine a valid hostname\n";
   print "WARNING: this may lead to problems with other programs that\n";
   print "WARNING: depend on globus-hostname. To avoid this please set the\n";
   print "WARNING: GLOBUS_HOSTNAME environment variable\n";
}

print "Done\n";

$metadata->finish();
