%{!?python_sitearch: %global python_sitearch %(%{__python} -c "from distutils.sysconfig import get_python_lib; print get_python_lib(1)")}
%{!?python_sitelib: %global python_sitelib %(%{__python} -c "from distutils.sysconfig import get_python_lib; print get_python_lib(0)")}

%if %{?rhel}%{!?rhel:0} == 5
%global __python26 %{_bindir}/python2.6
%{!?python26_sitearch: %global python26_sitearch %(%{__python26} -c "from distutils.sysconfig import get_python_lib; print get_python_lib(1)")}
%{!?python26_sitelib: %global python26_sitelib %(%{__python26} -c "from distutils.sysconfig import get_python_lib; print get_python_lib(0)")}
# Disable the default python byte compilation
%global __os_install_post %(echo '%{__os_install_post}' | sed -e 's!/usr/lib[^[:space:]]*/brp-python-bytecompile[[:space:]].*$!!g')
%endif

%if %{?filter_setup:1}%{!?filter_setup:0}
%filter_provides_in %{python_sitearch}.*\.so$
%if %{?rhel}%{!?rhel:0} == 5
%filter_provides_in %{python26_sitearch}.*\.so$
%endif
%if %{?fedora}%{!?fedora:0} >= 13
%filter_provides_in %{python3_sitearch}.*\.so$
%endif
%filter_setup
%endif

%if %{?fedora}%{!?fedora:0} >= 12 || %{?rhel}%{!?rhel:0}
%global with_xrootd  %{!?_without_xrootd:1}%{?_without_xrootd:0}
%else
%global with_xrootd  0
%endif

%global with_lfc  %{!?_without_lfc:1}%{?_without_lfc:0}

# Java 1.5.0 or later is needed for bindings (Fedora 7+)
%if %{?fedora}%{!?fedora:0} >= 7 || %{?rhel}%{!?rhel:0} >= 5
%global with_java %{!?_without_java:1}%{?_without_java:0}
%if %{?fedora}%{!?fedora:0} >= 7 || %{?rhel}%{!?rhel:0} >= 5
%global with_junit  %{!?_without_junit:1}%{?_without_junit:0}
%else
%global with_junit  0
%endif
%else
%global with_java 0
%endif
%global with_gcj  %{!?_with_gcj:0}%{?_with_gcj:1}

%if %{?fedora}%{!?fedora:0} >= 5 || %{?rhel}%{!?rhel:0} >= 5
%if %{?rhel}%{!?rhel:0} == 6
%ifarch ppc64
# The python module doesn't build on RHEL6 ppc64 (.toc1 section overflow)
%global with_python 0
%else
%global with_python 1
%endif
%else
%global with_python 1
%endif
%else
%global with_python 0
%endif

%if %{?fedora}%{!?fedora:0} >= 4 || %{?rhel}%{!?rhel:0} >= 5
%global with_pylint  %{!?_without_pylint:1}%{?_without_pylint:0}
%else
%global with_pylint  0
%endif

%if %{?fedora}%{!?fedora:0} >= 7 || %{?rhel}%{!?rhel:0} >= 5
%global with_acix 1
%else
%global with_acix 0
%endif

%if %{?fedora}%{!?fedora:0} >= 16 || %{?rhel}%{!?rhel:0} >= 5
%global with_gfal 1
%else
%global with_gfal 0
%endif

%if %{?fedora}%{!?fedora:0} >= 8 || %{?rhel}%{!?rhel:0} >= 4
%global with_canl %{!?_without_canl:1}%{?_without_canl:0}
%else
%global with_canl 0
%endif

%global pkgdir arc

Name:		nordugrid-arc
Version:	3.0.1
Release:	0.rc2%{?dist}
Summary:	Advanced Resource Connector Grid Middleware
Group:		System Environment/Daemons
License:	ASL 2.0
URL:		http://www.nordugrid.org/
Source:		http://download.nordugrid.org/packages/%{name}/releases/%{version}rc2/src/%{name}-%{version}rc2.tar.gz
BuildRoot:	%{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)

Provides:	%{name}-libs = %{version}-%{release}
Obsoletes:	%{name}-libs < 1.0.0
Provides:	nordugrid-arc1 = 1.3.0
Obsoletes:	nordugrid-arc1 < 1.0.0
Provides:	nordugrid-arc-nox = 1.3.0
Obsoletes:	nordugrid-arc-nox < 1.3.0
#		Packages dropped without replacements
Obsoletes:	%{name}-httpsd < 0.8.2-1
Obsoletes:	%{name}-logger-server < 0.8.2-1
Obsoletes:	nordugrid-arc1-janitor < 1.0.0
Obsoletes:	nordugrid-arc-nox-charon < 1.3.0
Obsoletes:	nordugrid-arc-nox-chelonia < 1.3.0
Obsoletes:	nordugrid-arc-nox-compiler < 1.3.0
Obsoletes:	nordugrid-arc-nox-delegation < 1.3.0
Obsoletes:	nordugrid-arc-nox-hopi < 1.3.0
Obsoletes:	nordugrid-arc-nox-isis < 1.3.0
Obsoletes:	nordugrid-arc-nox-janitor < 1.3.0
Obsoletes:	nordugrid-arc-nox-paul < 1.3.0
Obsoletes:	nordugrid-arc-nox-saml2sp < 1.3.0
Obsoletes:	nordugrid-arc-nox-slcs < 1.3.0
Obsoletes:	nordugrid-arc-chelonia < 2.0.0
Obsoletes:	nordugrid-arc-hopi < 2.0.0
Obsoletes:	nordugrid-arc-isis < 2.0.0
Obsoletes:	nordugrid-arc-janitor < 2.0.0

BuildRequires:	cppunit-devel
BuildRequires:	pkgconfig
%if %{?fedora}%{!?fedora:0} >= 12 || %{?rhel}%{!?rhel:0} >= 6
BuildRequires:	libuuid-devel
%else
BuildRequires:	e2fsprogs-devel
%endif
BuildRequires:	gettext
%if %{with_python}
BuildRequires:	python-devel
%endif
%if %{?rhel}%{!?rhel:0} == 5
BuildRequires:	python26-devel
%endif
%if %{?fedora}%{!?fedora:0} >= 13
BuildRequires:	python3-devel
%endif
%if %{with_pylint}
BuildRequires:	pylint
%endif
BuildRequires:	glibmm24-devel
BuildRequires:	glib2-devel
BuildRequires:	libxml2-devel
BuildRequires:	openssl
BuildRequires:	openssl-devel
BuildRequires:	xmlsec1-devel >= 1.2.4
BuildRequires:	xmlsec1-openssl-devel >= 1.2.4
%if %{?fedora}%{!?fedora:5} > 4 && %{?suse_version:0}%{!?suse_version:1}
BuildRequires:	nss-devel
%else
BuildRequires:	mozilla-nss-devel
%endif
BuildRequires:	openldap-devel
BuildRequires:	globus-common-devel
BuildRequires:	globus-ftp-client-devel
BuildRequires:	globus-ftp-control-devel
%if %{with_lfc}
BuildRequires:	lfc-devel
%endif
BuildRequires:	gridsite-devel
%if %{with_canl}
BuildRequires:	canl-c++-devel
%endif
%if %{with_xrootd}
%if %{?fedora}%{!?fedora:0} >= 17 || %{?rhel}%{!?rhel:0} >= 5
BuildRequires:	xrootd-client-devel
%else
BuildRequires:	xrootd-devel
%endif
%endif
%if %{with_gfal}
BuildRequires:	gfal2-devel
%endif
%if %{?suse_version}%{!?suse_version:0}
BuildRequires:	libdb-4_5-devel
%else
%if %{?fedora}%{!?fedora:0} >= 15 || %{?rhel}%{!?rhel:0} >= 7
BuildRequires:	libdb-cxx-devel
%else
%if %{?fedora}%{!?fedora:0} == 14
BuildRequires:	libdb-devel
%else
BuildRequires:	db4-devel
%endif
%endif
%endif
%if %{with_java}
BuildRequires:	java-devel
BuildRequires:	jpackage-utils
%if %{with_gcj}
BuildRequires:	java-gcj-compat-devel
%endif
%if %{with_junit}
BuildRequires:	junit
%endif
%endif
# Needed for infoprovider testing during make check
BuildRequires:	perl(XML::Simple)
# Needed for LRMS testing during make check
BuildRequires:	perl(Test::Harness)
BuildRequires:	perl(Test::Simple)
BuildRequires:	mktemp
# Needed to run ACIX unit tests
%if %{with_acix}
BuildRequires:	python-twisted-core
BuildRequires:	python-twisted-web
BuildRequires:	pyOpenSSL
%if %{?rhel}%{!?rhel:0} == 5
BuildRequires:	python-hashlib
%endif
%endif
%if %{?fedora}%{!?fedora:0} >= 6 || %{?rhel}%{!?rhel:0} >= 5
# The compilation of the selinux module fails on Fedora 5
BuildRequires:	selinux-policy-devel
BuildRequires:	checkpolicy
%endif
BuildRequires:	swig
%if %{?fedora}%{!?fedora:0} >= 4 || %{?rhel}%{!?rhel:0} >= 5
BuildRequires:	libtool-ltdl-devel
%else
BuildRequires:	libtool
%endif

%description
NorduGrid is a collaboration aiming at development, maintenance and
support of the free Grid middleware, known as the Advanced Resource
Connector (ARC).

The Advanced Resource Connector (ARC) brings computing resources
together across institutional boundaries. This concept is commonly
referred to as a "computational grid". Historically, grids address the
organization of distributed storage of data and parallel computation,
but could be expanded to arbitrary services.

Just like the web, ARC has its roots in the IT infrastructure that was
erected to analyze the experiments for high energy physics at CERN.
The first release, ARC-0.x, was dependent on Globus, the current
release keeps that compatibility but can also be used independently.

%package client
Summary:	ARC command line interface
Group:		Applications/Internet
Requires:	%{name} = %{version}-%{release}
Requires:	%{name}-plugins-needed = %{version}-%{release}
Provides:	nordugrid-arc1-client = 1.3.0
Obsoletes:	nordugrid-arc1-client < 1.0.0
Provides:	nordugrid-arc-nox-client = 1.3.0
Obsoletes:	nordugrid-arc-nox-client < 1.3.0

%description client
NorduGrid is a collaboration aiming at development, maintenance and
support of the free Grid middleware, known as the Advanced Resource
Connector (ARC).

For the regular user of any ARC-based computational grid,
this client package contains (or depends on) all packages
that are needed to submit jobs, query their status and
retrieve results.

%package hed
Summary:	ARC Hosting Environment Daemon
Group:		System Environment/Libraries
Requires:	%{name} = %{version}-%{release}
Provides:	nordugrid-arc1-server = 1.3.0
Obsoletes:	nordugrid-arc1-server < 1.0.0
Provides:	nordugrid-arc-nox-hed = 1.3.0
Obsoletes:	nordugrid-arc-nox-hed < 1.3.0

Requires(post):		chkconfig
Requires(preun):	chkconfig
Requires(preun):	initscripts
Requires(postun):	initscripts

%description hed
NorduGrid is a collaboration aiming at development, maintenance and
support of the free Grid middleware, known as the Advanced Resource
Connector (ARC).

The ARC Hosting Environment Daemon (HED). This daemon is a container for
ARC services.

%package gridftpd
Summary:	ARC gridftp server
Group:		System Environment/Daemons
Requires:	%{name} = %{version}-%{release}
Requires:	%{name}-plugins-globus
Provides:	nordugrid-arc-nox-gridftp-server = 1.3.0
Obsoletes:	nordugrid-arc-nox-gridftp-server < 1.3.0

Requires(post):		chkconfig
Requires(preun):	chkconfig
Requires(preun):	initscripts
Requires(postun):	initscripts

%description gridftpd
NorduGrid is a collaboration aiming at development, maintenance and
support of the free Grid middleware, known as the Advanced Resource
Connector (ARC).

This package contains the ARC gridftp server which has a plugin framework.
Current plugins include:

  fileplugin : Standard gridftp server based on Globus globus-ftp-control
  gaclplugin : Enhanced server with support for GACL authorization
  jobplugin  : Classical ARC job submission interface

%package cache-service
Summary:	ARC cache service
Group:		System Environment/Libraries
Requires:	%{name} = %{version}-%{release}
Requires:	%{name}-hed = %{version}-%{release}
Requires:	%{name}-plugins-needed = %{version}-%{release}
Provides:	nordugrid-arc-nox-cache-service = 1.3.0
Obsoletes:	nordugrid-arc-nox-cache-service < 1.3.0

Requires(post):		chkconfig
Requires(preun):	chkconfig
Requires(preun):	initscripts
Requires(postun):	initscripts

%description cache-service
NorduGrid is a collaboration aiming at development, maintenance and
support of the free Grid middleware, known as the Advanced Resource
Connector (ARC).

This package contains the ARC cache service. It provides a way to perform
some operations on the A-REX cache remotely. It can be especially helpful
for data management within a pilot job framework.

%package datadelivery-service
Summary:	ARC data delivery service
Group:		System Environment/Libraries
Requires:	%{name} = %{version}-%{release}
Requires:	%{name}-hed = %{version}-%{release}
Requires:	%{name}-plugins-needed = %{version}-%{release}

Requires(post):		chkconfig
Requires(preun):	chkconfig
Requires(preun):	initscripts
Requires(postun):	initscripts

%description datadelivery-service
NorduGrid is a collaboration aiming at development, maintenance and
support of the free Grid middleware, known as the Advanced Resource
Connector (ARC).

This package contains the ARC data delivery service.

%package ldap-infosys
Summary:	ARC LDAP information service
Group:		System Environment/Libraries
Provides:	%{name}-infosys-ldap = %{version}-%{release}
Obsoletes:	%{name}-infosys-ldap < 1.0.0
Provides:	nordugrid-arc-nox-ldap-infosys = 1.3.0
Obsoletes:	nordugrid-arc-nox-ldap-infosys < 1.3.0
%if %{?fedora}%{!?fedora:0} >= 10 || %{?rhel}%{!?rhel:0} >= 6
BuildArch:	noarch
%endif
Requires:	openldap-servers
Requires:	glue-schema >= 2.0.8
Requires:	bdii

Requires(post):		chkconfig
Requires(preun):	chkconfig
Requires(preun):	initscripts
Requires(postun):	initscripts

%if %{?fedora}%{!?fedora:0} >= 5 || %{?rhel}%{!?rhel:0} >= 5
Requires(post):		policycoreutils
Requires(postun):	policycoreutils
%if %{?fedora}%{!?fedora:0} >= 11 || %{?rhel}%{!?rhel:0} >= 6
Requires(post):		policycoreutils-python
Requires(postun):	policycoreutils-python
%endif
%endif

%description ldap-infosys
NorduGrid is a collaboration aiming at development, maintenance and
support of the free Grid middleware, known as the Advanced Resource
Connector (ARC).

This package contains the LDAP based information system for ARC.
This package is not self-contained. it should be pulled in by either
nordugrid-arc-arex to be a part of a local information system or by
nordugrid-arc-egiis to be a part of a EGIIS service.

%package aris
Summary:	ARC local information system
Group:		System Environment/Libraries
Requires:	%{name}-ldap-infosys = %{version}-%{release}
Requires:	bdii
Provides:	%{name}-infoindex = %{version}-%{release}
Obsoletes:	%{name}-infoindex < 0.8.2-1
Provides:	%{name}-infosys-ldap = %{version}-%{release}
Obsoletes:	%{name}-infosys-ldap < 1.0.0
Provides:	nordugrid-arc-nox-ldap-infosys = 1.3.0
Obsoletes:	nordugrid-arc-nox-ldap-infosys < 1.3.0
%if %{?fedora}%{!?fedora:0} >= 10 || %{?rhel}%{!?rhel:0} >= 6
BuildArch:	noarch
%endif
Requires:	openldap-servers
Requires:	glue-schema >= 2.0.8
Requires:	bdii

Requires(post):		chkconfig
Requires(preun):	chkconfig
Requires(preun):	initscripts
Requires(postun):	initscripts

%description aris
NorduGrid is a collaboration aiming at development, maintenance and
support of the free Grid middleware, known as the Advanced Resource
Connector (ARC).

This package contains the LDAP based information system for ARC.
This package is not self-contained but is closely connected to
nordugrid-arc-arex.

%package egiis
Summary:	ARC EGIIS service
Group:		System Environment/Libraries
Requires:	%{name}-ldap-infosys = %{version}-%{release}
Provides:	%{name}-infoindex = %{version}-%{release}
Obsoletes:	%{name}-infoindex < 0.8.2-1
Provides:	nordugrid-arc-nox-giis = 1.3.0
Obsoletes:	nordugrid-arc-nox-giis < 1.3.0
Requires:	openldap-servers
Requires:	glue-schema >= 2.0.8

%if %{?fedora}%{!?fedora:0} >= 6 || %{?rhel}%{!?rhel:0} >= 5
Requires(post):		policycoreutils
Requires(postun):	policycoreutils
%endif

%description egiis
NorduGrid is a collaboration aiming at development, maintenance and
support of the free Grid middleware, known as the Advanced Resource
Connector (ARC).

The EGIIS is the Information Index Service used by ARC, This service is
used to set up a ldap-based server that local information systems register
to.

%package ldap-monitor
Summary:	ARC LDAP monitor service
Group:		System Environment/Libraries
Requires:	%{name} = %{version}-%{release}
Provides:	%{name}-monitor = %{version}-%{release}
Obsoletes:	%{name}-monitor < 1.0.0
Requires:	php
Requires:	php-gd
Requires:	php-ldap
%if %{?fedora}%{!?fedora:0} >= 10 || %{?rhel}%{!?rhel:0} >= 6
BuildArch:	noarch
%endif

%description ldap-monitor
NorduGrid is a collaboration aiming at development, maintenance and
support of the free Grid middleware, known as the Advanced Resource
Connector (ARC).

This package contains the LDAP monitor system for ARC.
This package is self-contained. It is used to set up a web-based monitor
which pulls information from a EGIIS and shows it graphically.

%package ws-monitor
Summary:	ARC WS monitor service
Group:		System Environment/Libraries
Requires:	%{name} = %{version}-%{release}
%if %{?fedora}%{!?fedora:0} >= 10 || %{?rhel}%{!?rhel:0} >= 6
BuildArch:	noarch
%endif

%description ws-monitor
NorduGrid is a collaboration aiming at development, maintenance and
support of the free Grid middleware, known as the Advanced Resource
Connector (ARC).

This package contains the WS monitor system for ARC.
This package is self-contained. It is used to set up a web-based monitor
which pulls information from ISIS and shows it graphically.

%package arex
Summary:	ARC Remote EXecution service
Group:		System Environment/Libraries
Requires:	%{name} = %{version}-%{release}
Requires:	%{name}-hed = %{version}-%{release}
Requires:	%{name}-plugins-needed = %{version}-%{release}
Requires:	%{name}-python = %{version}-%{release}
Requires:	mktemp
Requires:	python-twisted-core
Requires:	python-twisted-web
Requires:	stomppy
Requires:	python-ldap
Requires:	python-dirq
Requires:	%{name}-aris = %{version}-%{release}
Provides:	%{name}-grid-manager = %{version}-%{release}
Obsoletes:	%{name}-grid-manager < 1.0.0
Provides:	%{name}-server = %{version}-%{release}
Obsoletes:	%{name}-server < 1.0.0
Provides:	nordugrid-arc1-arex = 1.3.0
Obsoletes:	nordugrid-arc1-arex < 1.0.0
Provides:	nordugrid-arc-nox-arex = 1.3.0
Obsoletes:	nordugrid-arc-nox-arex < 1.3.0

Requires(post):		chkconfig
Requires(preun):	chkconfig
Requires(preun):	initscripts
Requires(postun):	initscripts

%description arex
NorduGrid is a collaboration aiming at development, maintenance and
support of the free Grid middleware, known as the Advanced Resource
Connector (ARC).

The ARC Remote EXecution service (AREX) provides a service for the
execution of compute jobs and the transfer of input or output data.

%package plugins-needed
Summary:	ARC base plugins
Group:		System Environment/Libraries
Requires:	%{name} = %{version}-%{release}
Provides:	nordugrid-arc1-plugins-base = 1.3.0
Obsoletes:	nordugrid-arc1-plugins-base < 1.0.0
Provides:	nordugrid-arc-nox-plugins-base = 1.3.0
Obsoletes:	nordugrid-arc-nox-plugins-base < 1.3.0
Provides:	nordugrid-arc-plugins-base = %{version}-%{release}
Obsoletes:	nordugrid-arc-plugins-base < 1.0.0-0.b2

%description plugins-needed
NorduGrid is a collaboration aiming at development, maintenance and
support of the free Grid middleware, known as the Advanced Resource
Connector (ARC).

ARC base plugins. This includes the Message Chain Components (MCCs) and
Data Manager Components (DMCs).

%package plugins-globus
Summary:	ARC Globus plugins
Group:		System Environment/Libraries
Requires:	%{name} = %{version}-%{release}
Provides:	nordugrid-arc1-plugins-globus = 1.3.0
Obsoletes:	nordugrid-arc1-plugins-globus < 1.0.0
Provides:	nordugrid-arc-nox-plugins-globus = 1.3.0
Obsoletes:	nordugrid-arc-nox-plugins-globus < 1.3.0

%description plugins-globus
NorduGrid is a collaboration aiming at development, maintenance and
support of the free Grid middleware, known as the Advanced Resource
Connector (ARC).

ARC Globus plugins. This includes the Globus dependent Data Manager
Components (DMCs).

%if %{with_canl}
%package arcproxyalt
Summary:	ARC proxy client based on canl
Group:		Applications/Internet
Requires:	%{name} = %{version}-%{release}

%description arcproxyalt
NorduGrid is a collaboration aiming at development, maintenance and
support of the free Grid middleware, known as the Advanced Resource
Connector (ARC).

This package includes a preview of the arcproxy command based on canl.
%endif

%if %{with_xrootd}
%package plugins-xrootd
Summary:	ARC xrootd plugins
Group:		System Environment/Libraries
Requires:	%{name} = %{version}-%{release}

%description plugins-xrootd
NorduGrid is a collaboration aiming at development, maintenance and
support of the free Grid middleware, known as the Advanced Resource
Connector (ARC).

ARC xrootd plugins. These allow access to data through the xrootd protocol.
%endif

%if %{with_gfal}
%package plugins-gfal

Summary:	ARC Globus plugins
Group:		System Environment/Libraries
Requires:	%{name} = %{version}-%{release}

%description plugins-gfal
NorduGrid is a collaboration aiming at development, maintenance and
support of the free Grid middleware, known as the Advanced Resource
Connector (ARC).

ARC plugins for GFAL2. This allows third-party transfer and adds support
for several extra transfer protocols (rfio, dcap, gsidcap). Specific
protocol support is provided by separate gfal2-plugin packages.
%endif

%if %{with_acix}
%package acix-core
Summary:	ARC cache index - core
Group:		System Environment/Libraries
Requires:	python-twisted-core
Requires:	python-twisted-web
Requires:	pyOpenSSL
%if %{?rhel}%{!?rhel:0} == 5
Requires:	python-hashlib
%endif

%description acix-core
NorduGrid is a collaboration aiming at development, maintenance and
support of the free Grid middleware, known as the Advanced Resource
Connector (ARC).

Core components of the ARC Cache Index (ACIX).

%package acix-cache
Summary:	ARC cache index - cache server
Group:		System Environment/Libraries
Requires:	python-twisted-core
Requires:	python-twisted-web
Requires:	pyOpenSSL
%if %{?rhel}%{!?rhel:0} == 5
Requires:	python-hashlib
%endif
Requires:	%{name}-acix-core = %{version}-%{release}

%description acix-cache
NorduGrid is a collaboration aiming at development, maintenance and
support of the free Grid middleware, known as the Advanced Resource
Connector (ARC).

Cache server component of the ARC Cache Index (ACIX), usually installed
alongside A-REX. This component collects information on the content of
an A-REX cache.

%package acix-index
Summary:	ARC cache index - index server
Group:		System Environment/Libraries
Requires:	python-twisted-core
Requires:	python-twisted-web
Requires:	pyOpenSSL
%if %{?rhel}%{!?rhel:0} == 5
Requires:	python-hashlib
%endif
Requires:	%{name}-acix-core = %{version}-%{release}

%description acix-index
NorduGrid is a collaboration aiming at development, maintenance and
support of the free Grid middleware, known as the Advanced Resource
Connector (ARC).

Index server component of the ARC Cache Index (ACIX), usually installed
independently of any A-REX installation. This component pulls cache content
from cache servers and can be queried by clients for the location of cached
files.
%endif

%package devel
Summary:	ARC development files
Group:		Development/Libraries
Requires:	%{name} = %{version}-%{release}
Requires:	glibmm24-devel
Requires:	glib2-devel
Requires:	libxml2-devel
Requires:	openssl-devel
Provides:	%{name}-libs-devel = %{version}-%{release}
Obsoletes:	%{name}-libs-devel < 1.0.0
Provides:	nordugrid-arc1-devel = 1.3.0
Obsoletes:	nordugrid-arc1-devel < 1.0.0
Provides:	nordugrid-arc-nox-devel = 1.3.0
Obsoletes:	nordugrid-arc-nox-devel < 1.3.0

%description devel
NorduGrid is a collaboration aiming at development, maintenance and
support of the free Grid middleware, known as the Advanced Resource
Connector (ARC).

Header files and libraries needed to develop applications using ARC.

%if %{with_python}
%package python
Summary:	ARC Python wrapper
Group:		Development/Libraries
Requires:	%{name} = %{version}-%{release}
Provides:	nordugrid-arc1-python = 1.3.0
Obsoletes:	nordugrid-arc1-python < 1.0.0
Provides:	nordugrid-arc-nox-python = 1.3.0
Obsoletes:	nordugrid-arc-nox-python < 1.3.0

%description python
NorduGrid is a collaboration aiming at development, maintenance and
support of the free Grid middleware, known as the Advanced Resource
Connector (ARC).

Python bindings for ARC.
%endif

%if %{?rhel}%{!?rhel:0} == 5
%package python26
Summary:	ARC Python wrapper
Group:		Development/Libraries
Requires:	%{name} = %{version}-%{release}
Requires:	python(abi) = 2.6

%description python26
NorduGrid is a collaboration aiming at development, maintenance and
support of the free Grid middleware, known as the Advanced Resource
Connector (ARC).

Python bindings for ARC.
%endif

%if %{?fedora}%{!?fedora:0} >= 13
%package python3
Summary:	ARC Python wrapper
Group:		Development/Libraries
Requires:	%{name} = %{version}-%{release}

%description python3
NorduGrid is a collaboration aiming at development, maintenance and
support of the free Grid middleware, known as the Advanced Resource
Connector (ARC).

Python bindings for ARC.
%endif

%if %{with_java}
%package java
Summary:	ARC Java wrapper
Group:		Development/Libraries
Requires:	%{name} = %{version}-%{release}
Requires:	java
Requires:	jpackage-utils
%if %{with_gcj}
Requires(post):		java-gcj-compat
Requires(postun):	java-gcj-compat
%endif
Provides:	nordugrid-arc1-java = 1.3.0
Obsoletes:	nordugrid-arc1-java < 1.0.0
Provides:	nordugrid-arc-nox-java = 1.3.0
Obsoletes:	nordugrid-arc-nox-java < 1.3.0

%description java
NorduGrid is a collaboration aiming at development, maintenance and
support of the free Grid middleware, known as the Advanced Resource
Connector (ARC).

Java bindings for ARC.
%endif

%package doxygen
Summary:	ARC API documentation
Group:		Documentation
%if %{?fedora}%{!?fedora:0} >= 10 || %{?rhel}%{!?rhel:0} >= 6
BuildArch:	noarch
%endif

%description doxygen
NorduGrid is a collaboration aiming at development, maintenance and
support of the free Grid middleware, known as the Advanced Resource
Connector (ARC).

Reference to the ARC programming API. It is prepared with doxygen.

%package gridmap-utils
Summary:	NorduGrid authorization tools
Group:		Applications/Internet
Requires:	perl(Crypt::SSLeay)
Requires:	perl(SOAP::Lite)
Requires:	perl(Crypt::OpenSSL::X509)
%if %{?fedora}%{!?fedora:0} >= 10 || %{?rhel}%{!?rhel:0} >= 6
BuildArch:	noarch
%endif

%description gridmap-utils
NorduGrid is a collaboration aiming at development, maintenance and
support of the free Grid middleware, known as the Advanced Resource
Connector (ARC).

This package contains the ARC authorization machinery.
A prominent tool distributed in this package is the nordugridmap
script to collect user information from the virtual organizations.

%package ca-utils
Summary:	NorduGrid authentication tools
Group:		Applications/Internet
Requires:	fetch-crl
Requires(post):	fetch-crl
Requires(post):	chkconfig
%if %{?fedora}%{!?fedora:0} >= 10 || %{?rhel}%{!?rhel:0} >= 6
BuildArch:	noarch
%endif

%description ca-utils
NorduGrid is a collaboration aiming at development, maintenance and
support of the free Grid middleware, known as the Advanced Resource
Connector (ARC).

The nordugrid-arc-ca-utils packages has been obsoleted.
The functionality of the grid-update-crls tool is provided by the
fetch-crl tool in the fetch-crl package.

%package misc-utils
Summary:	NorduGrid misc tools
Group:		Applications/Internet
Requires:	%{name} = %{version}-%{release}
Requires:	%{name}-plugins-needed = %{version}-%{release}

%description misc-utils
NorduGrid is a collaboration aiming at development, maintenance and
support of the free Grid middleware, known as the Advanced Resource
Connector (ARC).

This package contains various for various tasks including testing. The
package is usually not required by users or sysadmins but mainly for
developers.

%prep
%setup -q -n %{name}-%{version}rc2

%if %{?fedora}%{!?fedora:0} <= 9 && %{?rhel}%{!?rhel:0} <= 5
# Older versions of SELinux does not have policy for open
cd selinux
sed -e 's/ open / /' -e /open/d -i %{name}-egiis.te
cd -
%endif

%build
%configure --disable-static \
%if ! %{with_java}
     --disable-java \
%endif
%if ! %{with_lfc}
     --disable-lfc \
%endif
%if ! %{with_python}
     --disable-python \
%endif
%if ! %{with_acix}
     --disable-acix \
%endif
%if %{with_gfal}
     --enable-gfal \
%endif
%if %{?rhel}%{!?rhel:0} == 5
     --with-altpython=python26 \
%endif
%if %{?fedora}%{!?fedora:0} >= 13
     --with-altpython=python3 \
%endif
%if %{with_canl}
     --enable-canlxx \
%endif
%if ! %{with_xrootd}
     --disable-xrootd \
%endif
     --disable-dbjstore \
     --disable-doc \
     --with-docdir=%{_docdir}/%{name}-%{version}

make %{?_smp_mflags}

%if %{?fedora}%{!?fedora:0} >= 6 || %{?rhel}%{!?rhel:0} >= 5
cd selinux
make -f /usr/share/selinux/devel/Makefile
cd -
%endif

%check
make check

%install
rm -rf $RPM_BUILD_ROOT

make install DESTDIR=$RPM_BUILD_ROOT

# Install Logrotate.
mkdir -p $RPM_BUILD_ROOT%{_sysconfdir}/logrotate.d
install -p -m 644 debian/%{name}-arex.logrotate \
    $RPM_BUILD_ROOT%{_sysconfdir}/logrotate.d/%{name}-arex
install -p -m 644 debian/%{name}-gridftpd.logrotate \
    $RPM_BUILD_ROOT%{_sysconfdir}/logrotate.d/%{name}-gridftpd
install -p -m 644 debian/%{name}-aris.logrotate \
    $RPM_BUILD_ROOT%{_sysconfdir}/logrotate.d/%{name}-aris
install -p -m 644 debian/%{name}-datadelivery-service.logrotate \
    $RPM_BUILD_ROOT%{_sysconfdir}/logrotate.d/%{name}-datadelivery-service

find $RPM_BUILD_ROOT -type f -name \*.la -exec rm -fv '{}' ';'

# libarcglobusutils is not part of the ARC api.
find $RPM_BUILD_ROOT -name libarcglobusutils.so -exec rm -fv '{}' ';'

# Turn off default enabling of the services
mkdir -p $RPM_BUILD_ROOT%{_initrddir}
sed -e 's/\(chkconfig: \) *[^ ]*/\1-/' \
    -e '/Default-Start/d' \
    -e 's/\(Default-Stop:\s*\).*/\10 1 2 3 4 5 6/' \
    -i $RPM_BUILD_ROOT%{_initrddir}/*

# Create log directory
mkdir -p $RPM_BUILD_ROOT%{_localstatedir}/log/arc

%find_lang %{name}

%if %{with_java} && %{with_gcj}
%{_bindir}/aot-compile-rpm
%endif

%if %{?fedora}%{!?fedora:0} >= 6 || %{?rhel}%{!?rhel:0} >= 5
cd selinux
mkdir -p $RPM_BUILD_ROOT%{_datadir}/selinux/packages/%{name}
install -p -m 644 %{name}-egiis.pp \
    $RPM_BUILD_ROOT%{_datadir}/selinux/packages/%{name}
cd -
%endif

%if %{?rhel}%{!?rhel:0} == 5
%{__python}    -c 'import compileall; compileall.compile_dir("'"$RPM_BUILD_ROOT"'", 10, "%{python_sitearch}", 1)' > /dev/null
%{__python} -O -c 'import compileall; compileall.compile_dir("'"$RPM_BUILD_ROOT"'", 10, "%{python_sitearch}", 1)' > /dev/null
%{__python26}	 -c 'import compileall; compileall.compile_dir("'"$RPM_BUILD_ROOT%{python26_sitearch}"'", 10, "%{python26_sitearch}", 1)' > /dev/null
%{__python26} -O -c 'import compileall; compileall.compile_dir("'"$RPM_BUILD_ROOT%{python26_sitearch}"'", 10, "%{python26_sitearch}", 1)' > /dev/null
%endif

#
# Remove examples and let RPM package them under /usr/share/doc using the doc macro
#
rm -rf $RPM_BUILD_ROOT%{_datadir}/%{pkgdir}/examples
make -C src/libs/data-staging/examples	DESTDIR=$PWD/docdir/devel  pkgdatadir= install-exampleDATA
make -C src/hed/libs/compute/examples	DESTDIR=$PWD/docdir/devel  pkgdatadir= install-exampleDATA
make -C src/hed/libs/data/examples	DESTDIR=$PWD/docdir/devel  pkgdatadir= install-exampleDATA
make -C src/hed/acc/PythonBroker	DESTDIR=$PWD/docdir/python pkgdatadir= install-exampleDATA
make -C python/examples			DESTDIR=$PWD/docdir/python pkgdatadir= install-exampleDATA
make -C java/examples			DESTDIR=$PWD/docdir/java   pkgdatadir= install-exampleDATA
make -C src/clients			DESTDIR=$PWD/docdir/client pkgdatadir= install-exampleDATA
make -C src/services/a-rex		DESTDIR=$PWD/docdir/arex   pkgdatadir= install-exampleDATA
make -C src/doc				DESTDIR=$PWD/docdir/base   pkgdatadir= install-exampleDATA
make -C src/tests/echo			DESTDIR=$PWD/docdir/hed    pkgdatadir= install-exampleDATA
make -C src/hed				DESTDIR=$PWD/docdir/hed    pkgdatadir= install-profileDATA


%clean
rm -rf $RPM_BUILD_ROOT

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%post plugins-globus -p /sbin/ldconfig

%postun plugins-globus -p /sbin/ldconfig

%post hed
/sbin/chkconfig --add arched

%preun hed
if [ $1 -eq 0 ]; then
  service arched stop > /dev/null 2>&1
  /sbin/chkconfig --del arched
fi

%postun hed
if [ $1 -ge 1 ]; then
  service arched condrestart > /dev/null 2>&1
fi

%post arex
/sbin/chkconfig --add a-rex

%preun arex
if [ $1 -eq 0 ]; then
  service a-rex stop > /dev/null 2>&1
  /sbin/chkconfig --del a-rex
fi

%postun arex
if [ $1 -ge 1 ]; then
  service a-rex condrestart > /dev/null 2>&1
fi

%post gridftpd
/sbin/chkconfig --add gridftpd

%preun gridftpd
if [ $1 -eq 0 ]; then
  service gridftpd stop > /dev/null 2>&1
  /sbin/chkconfig --del gridftpd
fi

%postun gridftpd
if [ $1 -ge 1 ]; then
  service gridftpd condrestart > /dev/null 2>&1
fi

%post cache-service
/sbin/chkconfig --add arc-cache-service

%preun cache-service
if [ $1 -eq 0 ]; then
  service arc-cache-service stop > /dev/null 2>&1
  /sbin/chkconfig --del arc-cache-service
fi

%postun cache-service
if [ $1 -ge 1 ]; then
  service arc-cache-service condrestart > /dev/null 2>&1
fi

%post datadelivery-service
/sbin/chkconfig --add arc-datadelivery-service

%preun datadelivery-service
if [ $1 -eq 0 ]; then
  service arc-datadelivery-service stop > /dev/null 2>&1
  /sbin/chkconfig --del arc-datadelivery-service
fi

%postun datadelivery-service
if [ $1 -ge 1 ]; then
  service arc-datadelivery-service condrestart > /dev/null 2>&1
fi

%post ldap-infosys
/sbin/chkconfig --add nordugrid-arc-slapd
/sbin/chkconfig --add nordugrid-arc-inforeg
%if %{?fedora}%{!?fedora:0} >= 5 || %{?rhel}%{!?rhel:0} >= 5
semanage port -a -t ldap_port_t -p tcp 2135 2>/dev/null || :
%endif

%preun ldap-infosys
if [ $1 -eq 0 ]; then
  service nordugrid-arc-slapd stop > /dev/null 2>&1
  service nordugrid-arc-inforeg stop > /dev/null 2>&1
  /sbin/chkconfig --del nordugrid-arc-slapd
  /sbin/chkconfig --del nordugrid-arc-inforeg
fi

%postun ldap-infosys
if [ $1 -ge 1 ]; then
  service nordugrid-arc-slapd condrestart > /dev/null 2>&1
  service nordugrid-arc-inforeg condrestart > /dev/null 2>&1
fi
%if %{?fedora}%{!?fedora:0} >= 5 || %{?rhel}%{!?rhel:0} >= 5
if [ $1 -eq 0 ]; then
  semanage port -d -t ldap_port_t -p tcp 2135 2>/dev/null || :
fi
%endif

%post aris
/sbin/chkconfig --add nordugrid-arc-bdii
%if %{?fedora}%{!?fedora:0} >= 5 || %{?rhel}%{!?rhel:0} >= 5
semanage fcontext -a -t slapd_etc_t "/var/run/arc/infosys/bdii-slapd\.conf" 2>/dev/null || :
semanage fcontext -a -t slapd_db_t "/var/lib/arc/bdii/db(/.*)?" 2>/dev/null || :
semanage fcontext -a -t slapd_var_run_t "/var/run/arc/bdii/db(/.*)?" 2>/dev/null || :
# Remove selinux labels for old arc bdii var dir
semanage fcontext -d -t slapd_db_t "/var/run/arc/bdii(/.*)?" 2>/dev/null || :
%endif

%preun aris
if [ $1 -eq 0 ]; then
  service nordugrid-arc-bdii stop > /dev/null 2>&1 || :
  /sbin/chkconfig --del nordugrid-arc-bdii
fi

%postun aris
if [ $1 -ge 1 ]; then
  service nordugrid-arc-bdii condrestart > /dev/null 2>&1 || :
fi
%if %{?fedora}%{!?fedora:0} >= 5 || %{?rhel}%{!?rhel:0} >= 5
if [ $1 -eq 0 ]; then
  semanage fcontext -d -t slapd_etc_t "/var/run/arc/infosys/bdii-slapd\.conf" 2>/dev/null || :
  semanage fcontext -d -t slapd_db_t "/var/lib/arc/bdii/db(/.*)?" 2>/dev/null || :
  semanage fcontext -d -t slapd_var_run_t "/var/run/arc/bdii/db(/.*)?" 2>/dev/null || :
fi
%endif

%triggerun aris -- bdii
service nordugrid-arc-bdii condrestart > /dev/null 2>&1 || :

%post egiis
%if %{?fedora}%{!?fedora:0} >= 6 || %{?rhel}%{!?rhel:0} >= 5
/usr/sbin/semodule -i %{_datadir}/selinux/packages/%{name}/%{name}-egiis.pp > /dev/null 2>&1 || :
/sbin/restorecon %{_sbindir}/arc-infoindex-relay
%endif

%postun egiis
%if %{?fedora}%{!?fedora:0} >= 6 || %{?rhel}%{!?rhel:0} >= 5
if [ $1 -eq 0 ] ; then
  /usr/sbin/semodule -r %{name}-egiis > /dev/null 2>&1 || :
fi
%endif

%if %{with_acix}
%post acix-cache
/sbin/chkconfig --add acix-cache

%preun acix-cache
if [ $1 -eq 0 ]; then
  service acix-cache stop > /dev/null 2>&1
  /sbin/chkconfig --del acix-cache
fi

%postun acix-cache
if [ $1 -ge 1 ]; then
  service acix-cache condrestart > /dev/null 2>&1 || :
fi

%post acix-index
/sbin/chkconfig --add acix-index

%preun acix-index
if [ $1 -eq 0 ]; then
  service acix-index stop > /dev/null 2>&1 || :
  /sbin/chkconfig --del acix-index
fi

%postun acix-index
if [ $1 -ge 1 ]; then
  service acix-index condrestart > /dev/null 2>&1 || :
fi
%endif

%if %{with_java} && %{with_gcj}
%post java
[ -x %{_bindir}/rebuild-gcj-db ] && %{_bindir}/rebuild-gcj-db
%endif

%if %{with_java} && %{with_gcj}
%postun java
[ -x %{_bindir}/rebuild-gcj-db ] && %{_bindir}/rebuild-gcj-db
%endif

%post ca-utils
# Enable and start CRL updates via cron for backward compatibility
/sbin/chkconfig fetch-crl-cron on
service fetch-crl-cron start > /dev/null 2>&1

%files -f %{name}.lang
%defattr(-,root,root,-)
%{_libdir}/libarccompute.so.*
%{_libdir}/libarccommunication.so.*
%{_libdir}/libarccommon.so.*
%{_libdir}/libarccredential.so.*
%{_libdir}/libarccredentialstore.so.*
%{_libdir}/libarccrypto.so.*
%{_libdir}/libarcdata.so.*
%{_libdir}/libarcdatastaging.so.*
%{_libexecdir}/%{pkgdir}/DataStagingDelivery
%{_libdir}/libarcdbxml.so.*
%{_libdir}/libarcloader.so.*
%{_libdir}/libarcmessage.so.*
%{_libdir}/libarcsecurity.so.*
%{_libdir}/libarcinfosys.so.*
%{_libdir}/libarcws.so.*
%{_libdir}/libarcwssecurity.so.*
%{_libdir}/libarcxmlsec.so.*
# We need to have libmodcrypto.so close to libarccrypto
%{_libdir}/%{pkgdir}/libmodcrypto.so
%{_libdir}/%{pkgdir}/libmodcrypto.apd
# We need to have libmodcredential.so close to libarccredential
%{_libdir}/%{pkgdir}/libmodcredential.so
%{_libdir}/%{pkgdir}/libmodcredential.apd
%{_libexecdir}/%{pkgdir}/arc-file-access
%dir %{_datadir}/%{pkgdir}/test-jobs
%{_datadir}/%{pkgdir}/test-jobs/test-job-*
%{_datadir}/%{pkgdir}/schema
%dir %{_datadir}/%{pkgdir}
%doc README AUTHORS LICENSE NOTICE ChangeLog
%doc docdir/base/*

%files client
%defattr(-,root,root,-)
%doc docdir/client/*
%{_bindir}/arcacl
%{_bindir}/arccat
%{_bindir}/arcclean
%{_bindir}/arccp
%{_bindir}/arcecho
%{_bindir}/arcget
%{_bindir}/arcinfo
%{_bindir}/arckill
%{_bindir}/arcls
%{_bindir}/arcmigrate
%{_bindir}/arcmkdir
%{_bindir}/arcrename
%{_bindir}/arcproxy
%{_bindir}/arcrenew
%{_bindir}/arcresub
%{_bindir}/arcresume
%{_bindir}/arcrm
%{_bindir}/arcslcs
%{_bindir}/arcstat
%{_bindir}/arcsub
%{_bindir}/arcsync
%{_bindir}/arctest
%{_bindir}/ngclient2arc
%config(noreplace) %{_sysconfdir}/%{pkgdir}/client.conf
%doc %{_mandir}/man1/arcacl.1*
%doc %{_mandir}/man1/arccat.1*
%doc %{_mandir}/man1/arcclean.1*
%doc %{_mandir}/man1/arccp.1*
%doc %{_mandir}/man1/arcecho.1*
%doc %{_mandir}/man1/arcget.1*
%doc %{_mandir}/man1/arcinfo.1*
%doc %{_mandir}/man1/arckill.1*
%doc %{_mandir}/man1/arcls.1*
%doc %{_mandir}/man1/arcmigrate.1*
%doc %{_mandir}/man1/arcmkdir.1*
%doc %{_mandir}/man1/arcrename.1*
%doc %{_mandir}/man1/arcproxy.1*
%doc %{_mandir}/man1/arcrenew.1*
%doc %{_mandir}/man1/arcresub.1*
%doc %{_mandir}/man1/arcresume.1*
%doc %{_mandir}/man1/arcrm.1*
%doc %{_mandir}/man1/arcslcs.1*
%doc %{_mandir}/man1/arcstat.1*
%doc %{_mandir}/man1/arcsub.1*
%doc %{_mandir}/man1/arcsync.1*
%doc %{_mandir}/man1/arctest.1*
%doc %{_mandir}/man1/ngclient2arc.1*

%files hed
%defattr(-,root,root,-)
%doc docdir/hed/*
%{_initrddir}/arched
%{_sbindir}/arched
%{_libdir}/%{pkgdir}/libecho.so
%{_libdir}/%{pkgdir}/libecho.apd
%{_datadir}/%{pkgdir}/profiles
%doc %{_mandir}/man8/arched.8*
%doc %{_mandir}/man5/arc.conf.5*

%files gridftpd
%defattr(-,root,root,-)
%{_initrddir}/gridftpd
%{_sbindir}/gridftpd
%{_libdir}/%{pkgdir}/jobplugin.*
%{_libdir}/%{pkgdir}/gaclplugin.*
%{_libdir}/%{pkgdir}/fileplugin.*
%config(noreplace) %{_sysconfdir}/logrotate.d/%{name}-gridftpd
%doc %{_mandir}/man8/gridftpd.8*

%files ldap-infosys
%defattr(-,root,root,-)
%{_initrddir}/nordugrid-arc-slapd
%{_initrddir}/nordugrid-arc-inforeg
%{_datadir}/%{pkgdir}/create-slapd-config
%{_datadir}/%{pkgdir}/create-inforeg-config
%{_datadir}/%{pkgdir}/config_parser_compat.sh
%{_datadir}/%{pkgdir}/grid-info-soft-register
%{_datadir}/%{pkgdir}/ldap-schema

%files aris
%defattr(-,root,root,-)
%{_initrddir}/nordugrid-arc-bdii
%{_datadir}/%{pkgdir}/create-bdii-config
%{_datadir}/%{pkgdir}/glue-generator.pl
%{_datadir}/%{pkgdir}/glite-info-provider-ldap
%{_datadir}/%{pkgdir}/qju.pl
%{_datadir}/%{pkgdir}/cluster.pl
%{_datadir}/%{pkgdir}/se.pl
%{_datadir}/%{pkgdir}/LRMS.pm
%{_datadir}/%{pkgdir}/Shared.pm
%{_datadir}/%{pkgdir}/ConfigParser.pm
%config(noreplace) %{_sysconfdir}/logrotate.d/%{name}-aris

%files egiis
%defattr(-,root,root,-)
%{_initrddir}/nordugrid-arc-egiis
%{_sbindir}/arc-infoindex-relay
%{_sbindir}/arc-infoindex-server
%{_mandir}/man8/arc-infoindex-relay.8*
%{_mandir}/man8/arc-infoindex-server.8*
%{_libdir}/%{pkgdir}/arc-infoindex-slapd-wrapper.so
%{_libdir}/%{pkgdir}/arc-infoindex-slapd-wrapper.apd
%if %{?fedora}%{!?fedora:0} >= 6 || %{?rhel}%{!?rhel:0} >= 5
%{_datadir}/selinux/packages/%{name}
%endif

%files ldap-monitor
%defattr(-,root,root,-)
%{_datadir}/%{pkgdir}/ldap-monitor/*
%doc %{_mandir}/man7/ldap-monitor.7*

%files ws-monitor
%defattr(-,root,root,-)
%{_datadir}/%{pkgdir}/ws-monitor/*
%doc %{_mandir}/man7/ws-monitor.7*

%files cache-service
%defattr(-,root,root,-)
%{_initrddir}/arc-cache-service
%{_libdir}/%{pkgdir}/libcacheservice.so
%{_libdir}/%{pkgdir}/libcacheservice.apd

%files datadelivery-service
%defattr(-,root,root,-)
%{_initrddir}/arc-datadelivery-service
%{_libdir}/%{pkgdir}/libdatadeliveryservice.so
%{_libdir}/%{pkgdir}/libdatadeliveryservice.apd
%config(noreplace) %{_sysconfdir}/logrotate.d/%{name}-datadelivery-service

%files arex
%defattr(-,root,root,-)
%doc docdir/arex/*
%{_initrddir}/a-rex
%{_libexecdir}/%{pkgdir}/cache-clean
%{_libexecdir}/%{pkgdir}/cache-list
%{_libexecdir}/%{pkgdir}/jura
%{_libexecdir}/%{pkgdir}/downloader
%{_libexecdir}/%{pkgdir}/gm-jobs
%{_libexecdir}/%{pkgdir}/gm-kick
%{_libexecdir}/%{pkgdir}/smtp-send
%{_libexecdir}/%{pkgdir}/smtp-send.sh
%{_libexecdir}/%{pkgdir}/uploader
%{_libexecdir}/%{pkgdir}/inputcheck
%{_libexecdir}/%{pkgdir}/arc-vomsac-check
%{_libexecdir}/%{pkgdir}/arc-ur-logger
%{_libexecdir}/%{pkgdir}/arc-ur-registrant
%{_libexecdir}/%{pkgdir}/arc-config-check
%{_datadir}/%{pkgdir}/cancel-*-job
%{_datadir}/%{pkgdir}/scan-*-job
%{_datadir}/%{pkgdir}/submit-*-job
%{_datadir}/%{pkgdir}/DGAuthplug.py*
%{_datadir}/%{pkgdir}/DGBridgeDataPlugin.py*
%{_datadir}/%{pkgdir}/DGLog2XML.py*
%{_libdir}/%{pkgdir}/libarex.so
%{_libdir}/%{pkgdir}/libarex.apd
%{_datadir}/%{pkgdir}/CEinfo.pl
%{_datadir}/%{pkgdir}/ARC0mod.pm
%{_datadir}/%{pkgdir}/FORKmod.pm
%{_datadir}/%{pkgdir}/Fork.pm
%{_datadir}/%{pkgdir}/SGEmod.pm
%{_datadir}/%{pkgdir}/SGE.pm
%{_datadir}/%{pkgdir}/LL.pm
%{_datadir}/%{pkgdir}/LSF.pm
%{_datadir}/%{pkgdir}/PBS.pm
%{_datadir}/%{pkgdir}/Condor.pm
%{_datadir}/%{pkgdir}/SLURMmod.pm
%{_datadir}/%{pkgdir}/SLURM.pm
%{_datadir}/%{pkgdir}/DGBridge.pm
%{_datadir}/%{pkgdir}/XmlPrinter.pm
%{_datadir}/%{pkgdir}/InfosysHelper.pm
%{_datadir}/%{pkgdir}/LdifPrinter.pm
%{_datadir}/%{pkgdir}/GLUE2xmlPrinter.pm
%{_datadir}/%{pkgdir}/GLUE2ldifPrinter.pm
%{_datadir}/%{pkgdir}/NGldifPrinter.pm
%{_datadir}/%{pkgdir}/ARC0ClusterInfo.pm
%{_datadir}/%{pkgdir}/ARC1ClusterInfo.pm
%{_datadir}/%{pkgdir}/ConfigCentral.pm
%{_datadir}/%{pkgdir}/GMJobsInfo.pm
%{_datadir}/%{pkgdir}/HostInfo.pm
%{_datadir}/%{pkgdir}/RTEInfo.pm
%{_datadir}/%{pkgdir}/InfoChecker.pm
%{_datadir}/%{pkgdir}/IniParser.pm
%{_datadir}/%{pkgdir}/LRMSInfo.pm
%{_datadir}/%{pkgdir}/Sysinfo.pm
%{_datadir}/%{pkgdir}/LogUtils.pm
%{_datadir}/%{pkgdir}/condor_env.pm
%{_datadir}/%{pkgdir}/cancel_common.sh
%{_datadir}/%{pkgdir}/config_parser.sh
%{_datadir}/%{pkgdir}/configure-*-env.sh
%{_datadir}/%{pkgdir}/submit_common.sh
%{_datadir}/%{pkgdir}/scan_common.sh
%doc %{_mandir}/man1/cache-clean.1*
%doc %{_mandir}/man1/cache-list.1*
%doc %{_mandir}/man1/jura.1*
%doc %{_mandir}/man8/gm-jobs.8*
%doc %{_mandir}/man1/arc-config-check.1*
%doc %{_mandir}/man8/arc-vomsac-check.8*
%config(noreplace) %{_sysconfdir}/logrotate.d/%{name}-arex
%dir %{_localstatedir}/log/arc
%if %{with_python}
%{_libexecdir}/%{pkgdir}/ssmsend
%{_datadir}/%{pkgdir}/ssm/__init__.py*
%{_datadir}/%{pkgdir}/ssm/crypto.py*
%{_datadir}/%{pkgdir}/ssm/ssm2.py*
%{_datadir}/%{pkgdir}/ssm/brokers.py*
%{_datadir}/%{pkgdir}/ssm/sender.cfg
%endif

%if %{with_acix}
%files acix-core
%defattr(-,root,root,-)
%{python_sitelib}/acix/__init__.py*
%{python_sitelib}/acix/core

%files acix-cache
%defattr(-,root,root,-)
%{python_sitelib}/acix/cacheserver
%{_initrddir}/acix-cache

%files acix-index
%defattr(-,root,root,-)
%{python_sitelib}/acix/indexserver
%{_initrddir}/acix-index
%endif

%files devel
%defattr(-,root,root,-)
%doc docdir/devel/*
%{_includedir}/%{pkgdir}
%{_libdir}/lib*.so
%{_bindir}/wsdl2hed
%doc %{_mandir}/man1/wsdl2hed.1*
%{_bindir}/arcplugin
%doc %{_mandir}/man1/arcplugin.1*
%{_libdir}/pkgconfig/arcbase.pc
%doc  src/hed/shc/arcpdp/*.xsd

%files plugins-needed
%defattr(-,root,root,-)
%{_libdir}/%{pkgdir}/libaccARC1.so
%{_libdir}/%{pkgdir}/libaccBroker.so
%{_libdir}/%{pkgdir}/libaccCREAM.so
%{_libdir}/%{pkgdir}/libaccEMIES.so
%{_libdir}/%{pkgdir}/libaccJobDescriptionParser.so
%{_libdir}/%{pkgdir}/libaccSER.so
%{_libdir}/%{pkgdir}/libaccldap.so
%{_libdir}/%{pkgdir}/test/libaccTEST.so
%{_libdir}/%{pkgdir}/libarcshc.so
%{_libdir}/%{pkgdir}/libarcshclegacy.so
%{_libdir}/%{pkgdir}/libdmcarc.so
%{_libdir}/%{pkgdir}/libdmcfile.so
%{_libdir}/%{pkgdir}/libdmchttp.so
%{_libdir}/%{pkgdir}/libdmcldap.so
%{_libdir}/%{pkgdir}/libdmcsrm.so
%{_libdir}/%{pkgdir}/libidentitymap.so
%{_libdir}/%{pkgdir}/libarguspdpclient.so
%{_libdir}/%{pkgdir}/libmcchttp.so
%{_libdir}/%{pkgdir}/libmccmsgvalidator.so
%{_libdir}/%{pkgdir}/libmccsoap.so
%{_libdir}/%{pkgdir}/libmcctcp.so
%{_libdir}/%{pkgdir}/libmcctls.so
%{_libdir}/%{pkgdir}/libaccARC1.apd
%{_libdir}/%{pkgdir}/libaccBroker.apd
%{_libdir}/%{pkgdir}/libaccCREAM.apd
%{_libdir}/%{pkgdir}/libaccEMIES.apd
%{_libdir}/%{pkgdir}/libaccJobDescriptionParser.apd
%{_libdir}/%{pkgdir}/libaccSER.apd
%{_libdir}/%{pkgdir}/libaccldap.apd
%{_libdir}/%{pkgdir}/test/libaccTEST.apd
%{_libdir}/%{pkgdir}/libarcshc.apd
%{_libdir}/%{pkgdir}/libarcshclegacy.apd
%{_libdir}/%{pkgdir}/libdmcarc.apd
%{_libdir}/%{pkgdir}/libdmcfile.apd
%{_libdir}/%{pkgdir}/libdmchttp.apd
%{_libdir}/%{pkgdir}/libdmcldap.apd
%{_libdir}/%{pkgdir}/libdmcsrm.apd
%{_libdir}/%{pkgdir}/libidentitymap.apd
%{_libdir}/%{pkgdir}/libarguspdpclient.apd
%{_libdir}/%{pkgdir}/libmcchttp.apd
%{_libdir}/%{pkgdir}/libmccsoap.apd
%{_libdir}/%{pkgdir}/libmcctcp.apd
%{_libdir}/%{pkgdir}/libmccmsgvalidator.apd
%{_libdir}/%{pkgdir}/libmcctls.apd

%files plugins-globus
%defattr(-,root,root,-)
%{_libdir}/%{pkgdir}/libaccARC0.so
%{_libdir}/%{pkgdir}/libdmcgridftp.so
%{_libdir}/%{pkgdir}/libaccARC0.apd
%{_libdir}/%{pkgdir}/libdmcgridftp.apd
%if %{with_lfc}
%{_libdir}/%{pkgdir}/libdmclfc.so
%{_libdir}/%{pkgdir}/libdmclfc.apd
%endif
%{_libdir}/%{pkgdir}/libmccgsi.so
%{_libdir}/%{pkgdir}/libmccgsi.apd
%{_libdir}/libarcglobusutils.so.*
%{_libexecdir}/%{pkgdir}/arc-lcas
%{_libexecdir}/%{pkgdir}/arc-lcmaps

%if %{with_canl}
%files arcproxyalt
%defattr(-,root,root,-)
%{_bindir}/arcproxyalt
%endif

%if %{with_xrootd}
%files plugins-xrootd
%defattr(-,root,root,-)
%{_libdir}/%{pkgdir}/libdmcxrootd.so
%{_libdir}/%{pkgdir}/libdmcxrootd.apd
%endif

%if %{with_gfal}
%files plugins-gfal
%defattr(-,root,root,-)
%{_libdir}/%{pkgdir}/libdmcgfal.so
%{_libdir}/%{pkgdir}/libdmcgfal.apd
%endif

%if %{with_python}
%files python
%defattr(-,root,root,-)
%doc docdir/python/*
%{python_sitearch}/arc
%{python_sitelib}/cache
%{python_sitelib}/echo_python
%{_libdir}/%{pkgdir}/libaccPythonBroker.so
%{_libdir}/%{pkgdir}/libaccPythonBroker.apd
%{_libdir}/%{pkgdir}/libpythonservice.so
%{_libdir}/%{pkgdir}/libpythonservice.apd
%endif

%if %{?rhel}%{!?rhel:0} == 5
%files python26
%defattr(-,root,root,-)
%{python26_sitearch}/arc
%endif

%if %{?fedora}%{!?fedora:0} >= 13
%files python3
%defattr(-,root,root,-)
%{python3_sitearch}/arc
%endif

%if %{with_java}
%files java
%defattr(-,root,root,-)
%doc docdir/java/*
%{_libdir}/java/libjarc.so
%{_libdir}/java/arc.jar
%{_libdir}/%{pkgdir}/libjavaservice.so
%{_libdir}/%{pkgdir}/libjavaservice.apd
%if %{with_gcj}
%{_libdir}/gcj/%{name}
%endif
%endif

%files doxygen
%defattr(-,root,root,-)
%doc src/doxygen/ARC1-API.pdf
%doc src/doxygen/ARC1-libarcdata.pdf

%files gridmap-utils
%defattr(-,root,root,-)
%{_sbindir}/nordugridmap
%config(noreplace) %{_sysconfdir}/cron.d/nordugridmap
%doc src/utils/gridmap/nordugridmap.conf
%doc %{_mandir}/man8/nordugridmap.8*

%files ca-utils
%defattr(-,root,root,-)

%files misc-utils
%defattr(-,root,root,-)
%{_bindir}/arcemiestest
%{_bindir}/arcwsrf
%{_bindir}/arcperftest
%{_bindir}/saml_assertion_init
%doc %{_mandir}/man1/arcemiestest.1*
%doc %{_mandir}/man1/arcwsrf.1*
%doc %{_mandir}/man1/arcperftest.1*
%doc %{_mandir}/man1/saml_assertion_init.1*

%changelog
* Fri Feb 22 2013 Anders Waananen <waananen@nbi.dk> - 3.0.0-1
- 3.0.0 Final Release

* Wed Feb 20 2013 Anders Waananen <waananen@nbi.dk> - 3.0.0-0.rc6
- 3.0.0 release candidate 6

* Wed Feb 20 2013 Anders Waananen <waananen@nbi.dk> - 3.0.0-0.rc6
- 3.0.0 release candidate 6

* Wed Feb 06 2013 Anders Waananen <waananen@nbi.dk> - 3.0.0-0.rc5
- 3.0.0 release candidate 5

* Sat Feb 02 2013 Anders Waananen <waananen@nbi.dk> - 3.0.0-0.rc4
- 3.0.0 release candidate 4

* Wed Jan 30 2013 Anders Waananen <waananen@nbi.dk> - 3.0.0-0.rc3
- 3.0.0 release candidate 3

* Mon Jan 28 2013 Anders Waananen <waananen@nbi.dk> - 3.0.0-0.rc2
- 3.0.0 release candidate 2

* Thu Dec 06 2012 Anders Waananen <waananen@nbi.dk> - 3.0.0-0.rc1
- 3.0.0 release candidate 1

* Thu Nov 08 2012 Anders Waananen <waananen@nbi.dk> - 2.0.1-1
- 2.0.1 Final Release

* Thu Oct 25 2012 Anders Waananen <waananen@nbi.dk> - 2.0.1-0.rc2
- 2.0.1 release candidate 2

* Fri Aug 24 2012 Anders Waananen <waananen@nbi.dk> - 2.0.1-0.rc1
- 2.0.1 release candidate 1

* Wed May 23 2012 Mattias Ellert <mattias.ellert@fysast.uu.se> - 2.0.0-1
- 2.0.0 Final Release

* Wed Apr 11 2012 Mattias Ellert <mattias.ellert@fysast.uu.se> - 2.0.0-0.rc4.1
- 2.0.0 release candidate 4.1

* Mon Apr 02 2012 Mattias Ellert <mattias.ellert@fysast.uu.se> - 2.0.0-0.rc4
- 2.0.0 release candidate 4

* Thu Mar 29 2012 Mattias Ellert <mattias.ellert@fysast.uu.se> - 2.0.0-0.rc3.2
- 2.0.0 release candidate 3.2

* Tue Mar 27 2012 Mattias Ellert <mattias.ellert@fysast.uu.se> - 2.0.0-0.rc3.1
- 2.0.0 release candidate 3.1

* Mon Mar 05 2012 Mattias Ellert <mattias.ellert@fysast.uu.se> - 2.0.0-0.rc3
- 2.0.0 release candidate 3

* Wed Feb 15 2012 Mattias Ellert <mattias.ellert@fysast.uu.se> - 2.0.0-0.rc2
- 2.0.0 release candidate 2

* Wed Feb 15 2012 Mattias Ellert <mattias.ellert@fysast.uu.se> - 1.1.1-1
- 1.1.1 Final Release

* Mon Oct 03 2011 Mattias Ellert <mattias.ellert@fysast.uu.se> - 1.1.0-1
- 1.1.0 Final Release

* Sun Sep 25 2011 Mattias Ellert <mattias.ellert@fysast.uu.se> - 1.1.0-0.rc2
- 1.1.0 release candidate 2

* Sun Sep 11 2011 Mattias Ellert <mattias.ellert@fysast.uu.se> - 1.1.0-0.rc1
- 1.1.0 release candidate 1

* Sat Jul 23 2011 Mattias Ellert <mattias.ellert@fysast.uu.se> - 1.0.1-1
- 1.0.1 Final Release

* Tue Jul 19 2011 Mattias Ellert <mattias.ellert@fysast.uu.se> - 1.0.1-0.rc4
- 1.0.1 release candidate 4

* Sat Jun 18 2011 Mattias Ellert <mattias.ellert@fysast.uu.se> - 1.0.1-0.rc1
- 1.0.1 release candidate 1

* Mon Apr 18 2011 Mattias Ellert <mattias.ellert@fysast.uu.se> - 1.0.0-1
- 1.0.0 Final Release

* Wed Apr 06 2011 Mattias Ellert <mattias.ellert@fysast.uu.se> - 1.0.0-0.b5
- 1.0.0 beta 5

* Wed Mar 23 2011 Mattias Ellert <mattias.ellert@fysast.uu.se> - 1.0.0-0.b4
- 1.0.0 beta 4

* Thu Mar 10 2011 Mattias Ellert <mattias.ellert@fysast.uu.se> - 1.0.0-0.b3
- 1.0.0 beta 3

* Mon Mar 07 2011 Mattias Ellert <mattias.ellert@fysast.uu.se> - 1.0.0-0.b2
- 1.0.0 Beta 2

* Mon Feb 14 2011 Mattias Ellert <mattias.ellert@fysast.uu.se> - 1.0.0-0.b1
- rename nordugrid-arc-nox → nordugrid-arc
- 1.0.0 Beta 1

* Tue Dec 21 2010 Mattias Ellert <mattias.ellert@fysast.uu.se> - 1.2.1-1
- 1.2.1 Final Release

* Tue Dec 21 2010 Mattias Ellert <mattias.ellert@fysast.uu.se> - 1.2.1-0.rc2
- 1.2.1 Release Candidate 2

* Wed Dec 08 2010 Mattias Ellert <mattias.ellert@fysast.uu.se> - 1.2.1-0.rc1
- 1.2.1 Release Candidate 1

* Fri Oct 22 2010 Mattias Ellert <mattias.ellert@fysast.uu.se> - 1.2.0-1
- 1.2.0 Final Release

* Thu Sep 30 2010 Mattias Ellert <mattias.ellert@fysast.uu.se> - 1.2.0-0.rc2
- 1.2.0 Release Candidate 2

* Mon Sep 13 2010 Mattias Ellert <mattias.ellert@fysast.uu.se> - 1.2.0-0.rc1
- 1.2.0 Release Candidate 1

* Wed May 05 2010 Mattias Ellert <mattias.ellert@fysast.uu.se> - 1.1.0-1
- 1.1.0 Final Release

* Mon Mar 08 2010 Mattias Ellert <mattias.ellert@fysast.uu.se> - 1.1.0-0.rc6
- 1.1.0 Release Candidate 6

* Fri Feb 26 2010 Mattias Ellert <mattias.ellert@fysast.uu.se> - 1.1.0-0.rc5.1
- Rebuild for Globus Toolkit 5

* Fri Feb 26 2010 Mattias Ellert <mattias.ellert@fysast.uu.se> - 1.1.0-0.rc5
- 1.1.0 Release Candidate 5

* Wed Feb 24 2010 Mattias Ellert <mattias.ellert@fysast.uu.se> - 1.1.0-0.rc4
- 1.1.0 Release Candidate 4

* Mon Feb 22 2010 Mattias Ellert <mattias.ellert@fysast.uu.se> - 1.1.0-0.rc3
- 1.1.0 Release Candidate 3

* Mon Feb 15 2010 Mattias Ellert <mattias.ellert@fysast.uu.se> - 1.1.0-0.rc2
- 1.1.0 Release Candidate 2

* Thu Feb 11 2010 Mattias Ellert <mattias.ellert@fysast.uu.se> - 1.1.0-0.rc1
- 1.1.0 Release Candidate 1

* Sun Nov 29 2009 Mattias Ellert <mattias.ellert@fysast.uu.se> - 1.0.0-1
- 1.0.0 Final Release

* Thu Nov 19 2009 Mattias Ellert <mattias.ellert@fysast.uu.se> - 1.0.0-0.rc7
- 1.0.0 Release Candidate 7

* Thu Nov 12 2009 Mattias Ellert <mattias.ellert@fysast.uu.se> - 1.0.0-0.rc6
- 1.0.0 Release Candidate 6

* Wed Nov 04 2009 Mattias Ellert <mattias.ellert@fysast.uu.se> - 1.0.0-0.rc5
- rename nordugrid-arc1 → nordugrid-arc-nox
- 1.0.0 Release candidate 5

* Mon Oct 26 2009 Mattias Ellert <mattias.ellert@fysast.uu.se> - 0.9.4-0.rc4
- 0.9.4 Release candidate 4

* Thu Oct 22 2009 Mattias Ellert <mattias.ellert@fysast.uu.se> - 0.9.4-0.rc3
- 0.9.4 Release candidate 3

* Wed Oct 14 2009 Mattias Ellert <mattias.ellert@fysast.uu.se> - 0.9.4-0.rc2
- 0.9.4 Release candidate 2

* Sun Sep 27 2009 Mattias Ellert <mattias.ellert@fysast.uu.se> - 0.9.3-1
- 0.9.3 Final release

* Thu Sep 17 2009 Mattias Ellert <mattias.ellert@fysast.uu.se> - 0.9.3-0.rc3
- 0.9.3 Release candidate 3

* Wed Jan 14 2009 Anders Wäänänen <waananen@nbi.dk> - 0.9.2-1
- 0.9.2

* Fri Oct 10 2008 Anders Wäänänen <waananen@nbi.dk> - 0.9.1-1
- Initial build
